/***************************************************************************/
/***************************************************************************/
/* The following files are required to run this example:                   */
/*   brr_pvalue_ci_macro_v1.1.sas                                          */
/*   diethealthout0-diethealthout16 (parameter estimates from the linear   */
/*     regression model fit for the original data and for each of the      */
/*     replicates)                                                         */
/***************************************************************************/
/*                                                                         */
/***************************************************************************/
/* This example analysis uses regression calibration and fits a linear     */
/* regression model to assess the relationship between a dietary component */
/* and a health outcome.  For this analysis, the example data include      */
/* males, ages 12+ from NHANES 2003-2004 and the 24-hour dietary recall is */
/* is the main dietary instrument.  The dietary component is red meat and  */
/* the health outcome is a continuous event variable.  The example data    */
/* include repeated intake measurements from 24-hour dietary recalls.      */
/*                                                                         */
/* This analysis uses balanced repeated replication (BRR) variance         */
/* estimation, so the univariate measurement error model and linear        */
/* regression model are fit using the original weight and 16 BRR weights.  */
/* This step of the example uses parameter estimates calculated from the   */
/* previous step and uses the BRR_PVALUE_CI macro to perform balanced      */
/* repeated replication (BRR) estimation of the standard errors.           */
/***************************************************************************/



title1 "Fit Univariate Measurement Error Model Using MLE with 24-Hour Recall as Main Instrument";
title2 "Predict Intake and Perform Regression Calibration";
title3 "Assess Relationship between a Dietary Component and a Health Outcome";
title4 "Balanced Repeated Replication (BRR) Estimation of Standard Errors";



***********************************************************************;
*** The path must be modified in the following lines to specify the ***;
*** location of the SAS macros, the SAS data files, and the SAS     ***;
*** library that will be used for output                            ***;
***********************************************************************;

%let home = /prj/dcp/statprog/meas.err/develop.public.resources.stat.meth;

*** Include the required macros ***;
%include "&home/include.files.macros/brr_pvalue_ci_macro_v1.1.sas";

*** Output data library ***;
libname outlib "&home/univar_epidemiology_example4_mle_main24hr/outlib";



/*****************************************************************************/
/*** Import the data sets of intermediate results needed for this example  ***/
/*** and create a data set with one record including parameter estimates   ***/
/*** from the original data and a data set with records 1, 2, ..., B       ***/
/*** including parameter estimates from replicate analyses performed for   ***/
/*** BRR variance estimation.                                              ***/
/*****************************************************************************/

data diethealthout0;
  set outlib.diethealthout0;
run;

data diethealthout_1to16;
  set outlib.diethealthout1-outlib.diethealthout16;
run;



/*****************************************************************************/
/*****************************************************************************/
/*                                                                           */
/* Description of the BRR_PVALUE_CI macro                                    */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/* The BRR_PVALUE_CI macro performs balanced repeated replication (BRR)      */
/* variance estimation, calculates a p-value for each user specified         */
/* parameter to test the null hypothesis that the parameter value is zero,   */
/* and calculates a confidence interval for each user specified parameter.   */
/* The macro produces an output data set including the parameter estimates,  */
/* the BRR standard error estimates, the p-value used to test the null       */
/* hypothesis that the parameter value is zero versus the alternative        */
/* hypothesis that the parameter value is not zero, and the lower and upper  */
/* confidence limits.                                                        */
/*                                                                           */
/* The macro input includes a data set with one record including parameter   */
/* estimates from the original data and a data set with records 1, 2, ...,   */
/* including parameter estimates from replicate analyses performed for BRR   */
/* variance estimation.  Optionally, Fay's BRR method can be specified.      */
/*                                                                           */
/* Reference:                                                                */
/*                                                                           */
/*   Korn EL, Graubard BI. Analysis of Health Surveys, John Wiley & Sons,    */
/*   Inc., New York, 1999.                                                   */
/*                                                                           */
/*                                                                           */
/* The syntax for calling the BRR_PVALUE_CI macro is:                        */
/*                                                                           */
/* %brr_pvalue_ci(data_orig_estimates_1rec =,                                */
/*                data_brr_estimates_brecs =,                                */
/*                param_estimate_names     =,                                */
/*                set_f_method_fay         =,                                */
/*                set_confidence_level     =,                                */
/*                set_degrees_freedom      =,                                */
/*                print                    =,                                */
/*                titles                   =                                 */
/*                );                                                         */
/*                                                                           */
/*  where                                                                    */
/*                                                                           */
/*  "data_orig_estimates_1rec"    Specifies an input data set that includes  */
/*                                one record with parameter estimates from   */
/*                                the original data.                         */
/*                                                                           */
/*  "data_brr_estimates_brecs"    Specifies an input data set that includes  */
/*                                records 1, 2, ..., B with parameter        */
/*                                estimates from replicate analyses          */
/*                                performed for balanced repeated            */
/*                                replication (BRR) variance estimation.     */
/*                                For example, record 1 includes the         */
/*                                parameter estimates obtained from          */
/*                                replicate 1, and record B includes the     */
/*                                parameter estimates obtained from          */
/*                                replicate B, i.e. the final replicate.     */
/*                                                                           */
/*  "param_estimate_names"        Specifies a list of parameter estimates    */
/*                                that are included as variables in the      */
/*                                input data sets specified for the          */
/*                                "data_orig_estimates_1rec" and             */
/*                                "data_brr_estimates_brecs" macro           */
/*                                parameters.                                */
/*                                                                           */
/*  "set_f_method_fay"            Specifies a value f that will be used to   */
/*                                define an adjustment factor 1/[(1-f)**2]   */
/*                                used to perform an appropriate adjustment  */
/*                                if Fay's BRR method was used to create the */
/*                                replicate weights.  The specified value    */
/*                                should be nonnegative and less than 1.     */
/*                                The default value is "0" so by default,    */
/*                                the BRR calculations are based on the      */
/*                                assumption that Fay's method was not used  */
/*                                to create the replicate weights.           */
/*                                                                           */
/*  "set_confidence_level"        Specifies the confidence level.  The       */
/*                                default value is "0.95".                   */
/*                                                                           */
/*  "set_degrees_freedom"         Specifies the degrees of freedom for the t */
/*                                distribution and for the denominator of    */
/*                                the F distribution.                        */
/*                                                                           */
/*  "print"                       If "print=n" or "print=N" then macro       */
/*                                results are not printed.  The default      */
/*                                value is "y".                              */
/*                                                                           */
/*  "titles"                      Specifies the number of title lines to be  */
/*                                reserved for the user's titles.  One       */
/*                                additional title line is used by the       */
/*                                macro.  The default value is "0".          */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/* Macro Output Data Set:  brr_pvalue_ci_out                                 */
/*                                                                           */
/* The BRR_PVALUE_CI macro produces a SAS data set "brr_pvalue_ci_out" that  */
/* includes the following variables:                                         */
/*               _name_, estimate, brr_se, pvalue_param0_probf_df_1_r,       */
/*               lowerlim_t_df_r, and upperlim_t_df_r                        */
/* where r is the value that was specified using the "set_degrees_freedom"   */
/* macro parameter.  The variable "_name_" identifies each parameter, and    */
/* the variable "estimate" includes the parameter estimates from the data    */
/* set specified using the "data_orig_estimates_1rec" macro parameter.  The  */
/* variable "brr_se" includes the BRR standard error estimates.  The         */
/* variable "pvalue_param0_probf_df_1_r" is the p-value used to test the     */
/* null hypothesis that the parameter value is zero versus the alternative   */
/* hypothesis that the parameter value is not zero.  The p-value is          */
/* calculated using the F distribution with 1 numerator degree of freedom    */
/* and r denominator degrees of freedom.  An equivalent p-value could be     */
/* obtained using the t distribution with r degrees of freedom.  The         */
/* variables "lowerlim_t_df_r" and "upperlim_t_df_r" are the lower and upper */
/* confidence limits which are calculated using the t distribution with r    */
/* degrees of freedom.                                                       */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************/

******************************************************************************;
***       Call the BRR_PVALUE_CI macro to calculate standard errors,       ***;
***                   p-values, and confidence intervals                   ***;
******************************************************************************;
*** Note that the degrees of freedom is specified as 15 (i.e. the number   ***;
*** of sampled primary sampling units (PSUs) minus the number of strata is ***;
*** 30-15=15 for NHANES 2003-2004). The degrees of freedom associated with ***;
*** replication variance estimators is discussed by Korn and Graubard      ***;
*** (1999, Analysis of Health Surveys, pg. 34) and in the documentation    ***;
*** for the SAS survey procedures.                                         ***;
******************************************************************************;

%brr_pvalue_ci(data_orig_estimates_1rec = diethealthout0,
               data_brr_estimates_brecs = diethealthout_1to16,
               param_estimate_names     = intercept rc_beta_unit,
               set_f_method_fay         = 0.3,
               set_confidence_level     = 0.95,
               set_degrees_freedom      = 15,
               print                    = y,
               titles                   = 4
               );
