#Produces probability density function plots for variables in dataset.
density_plots <- function(input.data,
                          variables=NULL,
                          row.subset=NULL,
                          weight=NULL,
                          population.name="All") {

  input.data <- as.data.frame(input.data)

  if(is.null(weight)) {

    subject.weighting <- rep(1, nrow(input.data))
  } else {

    subject.weighting <- input.data[,weight,drop=TRUE]
  }

  if(is.null(variables)) {

    variables <- names(input.data)
  }

  if(!is.null(row.subset)) {

    input.data <- input.data[row.subset,,drop=FALSE]
    subject.weighting <- subject.weighting[row.subset]
  }

  for(variable in variables) {

    variable.values <- input.data[,variable,drop=TRUE]
    file.name.variable <- gsub(".", "_", as.character(variable), fixed=TRUE)

    rescaled.weights <- subject.weighting/sum(subject.weighting)
    variable.density <- density(variable.values, weights=rescaled.weights, warnWbw=FALSE)

    plot(variable.density,
         main=paste0("Density Function of ", variable),
         sub=paste0("Population: ", population.name),
         xlab=variable,
         ylab="Estimated Density")
  }

  return(NULL)
}

#Produces empirical cumulative distribution function (ECDF) plots of variables in dataset.
ecdf_plots <- function(input.data,
                       variables=NULL,
                       row.subset=NULL,
                       weight=NULL,
                       population.name="All") {

  input.data <- as.data.frame(input.data)

  if(is.null(weight)) {

    subject.weighting <- rep(1, nrow(input.data))
  } else {

    subject.weighting <- input.data[,weight,drop=TRUE]
  }

  if(is.null(variables)) {

    variables <- names(input.data)
  }

  if(!is.null(row.subset)) {

    input.data <- input.data[row.subset,,drop=FALSE]
    subject.weighting <- subject.weighting[row.subset]
  }

  for(variable in variables) {

    variable.values <- input.data[,variable,drop=TRUE]
    file.name.variable <- gsub(".", "_", as.character(variable), fixed=TRUE)

    value.order <- order(variable.values)
    sorted.values <- variable.values[value.order]
    sorted.weights <- subject.weighting[value.order]
    cumulative.freq <- cumsum(sorted.weights)/sum(sorted.weights)

    variable.ecdf <- stepfun(sorted.values, c(0,cumulative.freq))

    plot(variable.ecdf,
         do.points=FALSE,
         main=paste0("Empirical Cumulative Density of ", variable),
         sub=paste0("Population: ", population.name),
         xlab=variable,
         ylab="Cumulative Density")
  }

  return(NULL)
}
