# Multivariate NCI Method Utilities


## Installing the Package

Manual Download:

    1. Download the package and save it to a folder.
    2. Use the following command in R:

	     install.packages("/path/to/package/file.tar.gz", repos=NULL, type="source")

       The first argument should be replaced with the package file that was downloaded in Step #1.


## Core Workflow Functions

The following functions form the core workflow of the multivariate NCI method, in order:

	1. boxcox_survey()
	2. nci_multivar_preprocessor()
	3. nci_multivar_mcmc()
	4. nci_multivar_distrib()
	5. nci_multivar_summary()


## Vignettes

This package contains tutorial vignettes to help acquaint yourself with the multivariate NCI method workflow.

The simplest way to access vignettes is using the following command in R:

	browseVignettes("ncimultivar")

This will open an HTML document in your browser that will show the available vignettes and the formats that they are available in.
It is recommended to start with "NCI Method Daily Nutrient".

The 'HTML' format will open another browser page that shows a formatted version of the tutorial. 
The code on this page cannot be interacted with, but any output will be displayed under the appropriate code section.

The 'source' option displays the vignette as an R Markdown file. 
The 'R code' option will display the vignette as ordinary R code.
The code from the 'source' and 'R code' options can be downloaded and opened in any compatible editor (for example, R studio).
