% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_parameters.R
\name{burn_and_thin}
\alias{burn_and_thin}
\title{Modify Burn-In and Thinning for MCMC Model}
\usage{
burn_and_thin(
  multivar.mcmc.model,
  num.mcmc.iterations = NULL,
  num.burn = NULL,
  num.thin = NULL
)
}
\arguments{
\item{multivar.mcmc.model}{An \code{nci.multivar.mcmc} object.}

\item{num.mcmc.iterations}{An integer specifying the new total number of
iterations in the MCMC chain, including burn-in.}

\item{num.burn}{An integer specifying the new number of burn-in iterations in
the MCMC chain.}

\item{num.thin}{An integer specifying the new number of iterations between
MCMC samples used for calculating posterior means.}
}
\value{
An \code{nci.multivar.mcmc} object with the total number of MCMC
iterations, burn-in iterations, and thinning value updated to the new
values.
}
\description{
This function modifies the burn-in and thinning values of an
\code{nci.multivar.mcmc} object that are used to calculate posterior means and
covariances. This can be useful for determining the impact of different
values and finding optimal numbers that balance accuracy and computation
speed.
}
\details{
Since \code{nci.multivar.mcmc} objects save MCMC samples from every
iteration, the number of iterations, burn-in, and thinning values used to
calculate posterior means and covariances can be changed. This utility can
be used to update those values while performing error-checking.

For models with stored random effect ('u') matrices from the main MCMC
chain, not all 'u' matrices are stored by default. As a result, the burn-in
for models with main MCMC chain 'u' matrices cannot be decreased, and the
new thinning value must be a multiple of the original thinning value. An
error will be thrown if 'u' matrices are not found for the new thinned
iterations.

Since changing the number of iterations, burn-in, and thinning can alter
the posterior means, post-MCMC 'u' matrix draws conditional on the
posterior mean may not be valid and will throw a warning.
}
\examples{
#subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

boxcox.lambda.data <- boxcox_survey(input.data=nhanes.subset,
                                    row.subset=(nhanes.subset$DAY == 1),
                                    variable="TSODI",
                                    id="SEQN",
                                    repeat.obs="DAY",
                                    weight="WTDRD1",
                                    covariates="RIDAGEYR")

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=nhanes.subset,
                                           daily.variables="TSODI",
                                           continuous.covariates="RIDAGEYR",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

mcmc.output <- nci_multivar_mcmc(pre.mcmc.data=pre.mcmc.data,
                                 id="SEQN",
                                 weight="WTDRD1",
                                 repeat.obs="DAY",
                                 daily.variables="TSODI",
                                 default.covariates="std.RIDAGEYR",
                                 num.mcmc.iterations=1000,
                                 num.burn=500,
                                 num.thin=1)

#original iteration numbers
mcmc.output$num.mcmc.iterations
mcmc.output$num.burn
mcmc.output$num.thin

mcmc.output <- burn_and_thin(multivar.mcmc.model=mcmc.output,
                             num.burn=200,
                             num.thin=2)

#new iteration numbers
mcmc.output$num.mcmc.iterations
mcmc.output$num.burn
mcmc.output$num.thin
}
