% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_trace_plots.R
\name{trace_plots}
\alias{trace_plots}
\title{MCMC Trace Plots}
\usage{
trace_plots(
  multivar.mcmc.model,
  do.beta = TRUE,
  do.sigma.e = TRUE,
  do.sigma.u = TRUE,
  do.sigma.overlay = FALSE,
  do.alpha1 = TRUE,
  do.consumer.probability = TRUE,
  plot.type = "value"
)
}
\arguments{
\item{multivar.mcmc.model}{An \code{nci.multivar.mcmc} object.}

\item{do.beta}{Flag to specify whether trace plots of fixed effect ('beta')
coefficients should be produced. (default = \code{TRUE})}

\item{do.sigma.e}{Flag to specify whether trace plots of residual error
covariance matrix ('Sigma-e') elements should be produced. (default =
\code{TRUE})}

\item{do.sigma.u}{Flag to specify whether trace plots of random effect
covariance matrix ('Sigma-u') elements should be produced. (default =
\code{TRUE})}

\item{do.sigma.overlay}{Flag to specify whether overlays of 'Sigma-e' and
'Sigma-u' element trace plots should be produced. (default = \code{FALSE})}

\item{do.alpha1}{Flag to specify whether trace plots of never-consumer model
('alpha1') coefficients should be produced. No effect if no never-consumer
variable was modeled. (default = \code{TRUE})}

\item{do.consumer.probability}{Flag to specify whether trace plots of mean
consumer probability should be produced. No effect if no never-consumer
variable was modeled. (default = \code{TRUE})}

\item{plot.type}{A character vector specifying what types of plots to
generate. One or both of the following can be specified:
\itemize{
\item \code{"value"}: Plots of a parameter's value at every MCMC iteration. This is the standard type of trace plot. (default)
\item \code{"mean"}: Plots of the rolling mean of a parameter at thinned MCMC iterations after the burn-in period.
}}
}
\value{
\code{NULL}. This function does not produce a return value, instead it
outputs the trace plots that were created into PDF files in the current
working directory.
}
\description{
Generate trace plots from an \code{nci.multivar.mcmc} object.
}
\details{
Trace plots are a method of assessing the convergence of MCMC chain.
The value of an MCMC parameter (such as a coefficient or a covariance
matrix element) is plotted against the number of iterations to see how the
value fluctuates over time. Plots of the parameter values and rolling
means can be produced. A parameter value that moves around a fixed point with
a uniform variance over time is said to have converged or "mixed well". For
more information, please see the trace plots vignette.
}
\examples{
#subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

boxcox.lambda.data <- boxcox_survey(input.data=nhanes.subset,
                                    row.subset=(nhanes.subset$DAY == 1),
                                    variable="TSODI",
                                    id="SEQN",
                                    repeat.obs="DAY",
                                    weight="WTDRD1",
                                    covariates="RIDAGEYR")

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=nhanes.subset,
                                           daily.variables="TSODI",
                                           continuous.covariates="RIDAGEYR",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

mcmc.output <- nci_multivar_mcmc(pre.mcmc.data=pre.mcmc.data,
                                 id="SEQN",
                                 weight="WTDRD1",
                                 repeat.obs="DAY",
                                 daily.variables="TSODI",
                                 default.covariates="std.RIDAGEYR",
                                 num.mcmc.iterations=1000,
                                 num.burn=500,
                                 num.thin=1)

#display trace plots
trace_plots(mcmc.output)
}
