**Create dataset of indicator and amount variables;
%macro process_variable_lists(pre_mcmc_data=,
															episodic_variables=,
															episodic_indicators=,
															episodic_amounts=,
															daily_variables=,
															daily_amounts=,
															never_consumer_variable=,
															never_consumer_indicator=,
															never_consumer_amount=,
															outname=);
															
	%local num_episodic num_daily i variable
				 has_never_consumers
				 is_nci_multivar;

	data _NULL_;
		_dsid = open("&pre_mcmc_data._mcmc_in");
		_check = (varnum(_dsid, "_nci_multivar") ^= 0);
		
		call symputx("is_nci_multivar", _check);
	run;
	
	%if &is_nci_multivar. = 1 %then %do;
	
		**if the input data is from the NCI multivar preprocessor, fill in indicators and amounts using appropriate prefixes;
		%if &episodic_indicators. = %str() and &episodic_variables. ^= %str() %then %do;
		
			%let num_episodic = %sysfunc(countw(&episodic_variables., %str( )));
			%do i = 1 %to &num_episodic.;
			
				%let episodic_indicators = &episodic_indicators. ind_%sysfunc(scan(&episodic_variables., &i., %str( )));
			%end;
		%end;
		
		%if &episodic_amounts. = %str() and &episodic_variables. ^= %str() %then %do;
		
			%let num_episodic = %sysfunc(countw(&episodic_variables., %str( )));
			%do i = 1 %to &num_episodic.;
			
				%let episodic_amounts = &episodic_amounts. amt_%sysfunc(scan(&episodic_variables., &i., %str( )));
			%end;
		%end;
		
		%if &daily_amounts. = %str() and &daily_variables. ^= %str() %then %do;
		
			%let num_daily = %sysfunc(countw(&daily_variables., %str( )));
			%do i = 1 %to &num_daily.;
			
				%let daily_amounts = &daily_amounts. amt_%sysfunc(scan(&daily_variables, &i., %str( )));
			%end;
		%end;
		
		%if &never_consumer_indicator. = %str() and &never_consumer_variable. ^= %str() %then %do;
		
			%let never_consumer_indicator = ind_&never_consumer_variable.;
		%end;
		
		%if &never_consumer_amount. = %str() and &never_consumer_variable. ^= %str() %then %do;
		
			%let never_consumer_amount = amt_&never_consumer_variable.;
		%end;
	%end;
	
	**if raw variables are not provided, match amounts to the backtransformation variables;
	%if &episodic_amounts. ^= %str() and &episodic_variables. = %str() %then %do;
	
		%let num_episodic = %sysfunc(countw(&episodic_amounts., %str( )));
		%do i = 1 %to &num_episodic.;
		
			%let amount = %sysfunc(scan(&episodic_amounts., &i., %str( )));
		
			data _NULL_;
				set &pre_mcmc_data._backtran;
				
				if find("&amount.", variable) ^= 0 then call symputx("variable", variable);
			run;
			
			%let episodic_variables = &episodic_variables. &variable.;
		%end;
	%end;
	
	%if &daily_amounts. ^= %str() and &daily_variables. = %str() %then %do;
	
		%let num_daily = %sysfunc(countw(&daily_amounts., %str( )));
		%do i = 1 %to &num_daily.;
		
			%let amount = %sysfunc(scan(&daily_amounts., &i., %str( )));
			
			data _NULL_;
				set &pre_mcmc_data._backtran;
				
				if find("&amount.", variable) ^= 0 then call symputx("variable", variable);
			run;
			
			%let daily_variable = &daily_variables. &variable.;
		%end;
	%end;
	
	%if &never_consumer_amount. ^= %str() and &never_consumer_variable. = %str() %then %do;
	
		data _NULL_;
			set &pre_mcmc_data._backtran;
				
			if find("&never_consumer_amount.", variable) ^= 0 then call symputx("never_consumer_variable", variable);
		run;
	%end;
	
	%if &never_consumer_variable. ^= %str() %then %do;
	
		%let has_never_consumers = 1;
	%end;
	%else %do;
	
		%let has_never_consumers = 0;
	%end;
	
	**place never consumer variable first in episodic variable list as required by the MCMC algorithm;
	%if &has_never_consumers. = 1 %then %do;
	
		data _NULL_;
		
			length episodic_variables $32767.;
			length episodic_indicators $32767.;
			length episodic_amounts $32767.;
			
			index = findw("&episodic_variables.", "&never_consumer_variable.", " ", "ei");
			
			episodic_variables = "&never_consumer_variable.";
			episodic_indicators = "&never_consumer_indicator.";
			episodic_amounts = "&never_consumer_amount.";
			
			do i = 1 to countw("&episodic_variables.");
			
				if i ^= index then do;
				
					episodic_variables = catx(" ", episodic_variables, scan("&episodic_variables.", i));
					episodic_indicators = catx(" ", episodic_indicators, scan("&episodic_indicators.", i));
					episodic_amounts = catx(" ", episodic_amounts, scan("&episodic_amounts.", i));
				end;
			end;
			
			call symputx("episodic_variables", episodic_variables);
			call symputx("episodic_indicators", episodic_indicators);
			call symputx("episodic_amounts", episodic_amounts);
		run;
	%end;
	
	**Output processed variable lists in dataset;	
	data &outname._vars;
	
		%do i = 1 %to %sysfunc(countw(&episodic_variables., %str( )));
		
			episodic_var&i. = "%sysfunc(scan(&episodic_variables., &i., %str( )))";
			episodic_ind&i. = "%sysfunc(scan(&episodic_indicators., &i., %str( )))";
			episodic_amt&i. = "%sysfunc(scan(&episodic_amounts., &i., %str( )))";
		%end;
		num_episodic = %sysfunc(countw(&episodic_variables., %str( )));
		
		%do i = 1 %to %sysfunc(countw(&daily_variables., %str( )));
		
			daily_var&i. = "%sysfunc(scan(&daily_variables., &i., %str( )))";
			daily_amt&i. = "%sysfunc(scan(&daily_amounts., &i., %str( )))";
		%end;
		num_daily = %sysfunc(countw(&daily_variables., %str( )));
		
		has_never_consumers = &has_never_consumers.;
	run;
	
	**Output backtransformation data;
	data &outname._backtran;
		set &pre_mcmc_data._backtran;
	run;
%mend process_variable_lists;

**Create datasets of covariates for each variable;
%macro process_covariate_lists(variable_data=,
												 			 default_covariates=,
												 			 episodic_indicator_covariates=,
												 			 episodic_amount_covariates=,
												 			 daily_amount_covariates=,
												 			 individual_covariates=,
												 			 default_intercept=,
												 			 episodic_indicator_intercept=,
												 			 episodic_amount_intercept=,
												 			 daily_amount_intercept=,
												 			 individual_intercept=,
												 			 never_consumer_covariates=,
												 			 never_consumer_intercept=,
												 			 outname=);
												 			 
	%local episodic_indicators episodic_amounts daily_amounts
				 num_variables num_episodic num_daily i var_j variable
				 covariates intercept
				 has_never_consumers;

	**extract variables;
	data _NULL_;
		set &variable_data.;
		
		call symputx("num_episodic", num_episodic);
		call symputx("num_daily", num_daily);
	run;
	
	data _NULL_;
		set &variable_data.;
		
		%if &num_episodic. > 0 %then %do;
			episodic_indicators = catx(" ", of episodic_ind1-episodic_ind&num_episodic.);
			episodic_amounts = catx(" ", of episodic_amt1-episodic_amt&num_episodic.);
		%end;
		
		%if &num_daily. > 0 %then %do;
			daily_amounts = catx(" ", of daily_amt1-daily_amt&num_daily.);
		%end;
		
		call symputx("episodic_indicators", episodic_indicators);
		call symputx("episodic_amounts", episodic_amounts);
		call symputx("daily_amounts", daily_amounts);
		
		call symputx("has_never_consumers", has_never_consumers);
	run;
	
	%let all_variables=;
	
	%do i = 1 %to &num_episodic.;
	
		%let all_variables = &all_variables. %sysfunc(scan(&episodic_indicators., &i., %str( )));
		%let all_variables = &all_variables. %sysfunc(scan(&episodic_amounts., &i., %str( )));
	%end;
	
	%do i = 1 %to &num_daily.;
	
		%let all_variables = &all_variables. %sysfunc(scan(&daily_amounts., &i., %str( )));
	%end;
	
	
	**Create dataset of covariates for each variable;	
	%let num_variables = %sysfunc(countw(&all_variables., %str( )));
	%do var_j = 1 %to &num_variables.;
	
		%let variable = %sysfunc(scan(&all_variables., &var_j., %str( )));
		
		%let covariates = &default_covariates.;
		
		%if %sysfunc(findw(&episodic_indicators., &variable., , %str(s))) ^= 0 and &episodic_indicator_covariates. ^= %str() %then %do;
			
			%let covariates = &episodic_indicator_covariates.;
		%end;
		
		%if %sysfunc(findw(&episodic_amounts., &variable., , %str(s))) ^= 0 and &episodic_amount_covariates. ^= %str() %then %do;
			
			%let covariates = &episodic_amount_covariates.;
		%end;
		
		%if %sysfunc(findw(&daily_amounts., &variable., , %str(s))) ^= 0 and &daily_amount_covariates. ^= %str() %then %do;
			
			%let covariates = &daily_amount_covariates.;
		%end;
		
		%if &individual_covariates. ^= %str() %then %do;
		
			data _NULL_;
				set &individual_covariates.;
				
				if compare(variable, "&variable.", "i") = 0 then call symputx("covariates", covariates);
			run;
		%end;
		
		%let intercept = &default_intercept.;

		%if %sysfunc(findw(&episodic_indicators., &variable., , %str(s))) ^= 0 and &episodic_indicator_intercept. ^= %str() %then %do;
		
			%let intercept = &episodic_indicator_intercept.;
		%end;
		
		%if %sysfunc(findw(&episodic_amounts., &variable., , %str(s))) ^= 0 and &episodic_amount_intercept. ^= %str() %then %do;
		
			%let intercept = &episodic_amount_intercept.;
		%end;
		
		%if %sysfunc(findw(&daily_amounts., &variable., , %str(s))) ^= 0 and &daily_amount_intercept. ^= %str() %then %do;
		
			%let intercept = &daily_amount_intercept.;
		%end;
		
		%if &individual_intercept ^= %str() %then %do;
		
			data _NULL_;
				set &individual_intercept.;
				
				if compare(variable, "&variable.", "i") = 0 then call symputx("intercept", intercept);
			run;
		%end;
		
		data _covars&var_j.;
		
			%do i = 1 %to %sysfunc(countw(&covariates., %str( )));
			
				length covariate&i. $32.;
				covariate&i. = "%sysfunc(scan(&covariates., &i., %str( )))";
			%end;
			num_covariates = %sysfunc(countw(&covariates., %str( )));
			
			length intercept $1.;
			intercept = "&intercept.";
			
			length variable $32.;
			variable = "&variable.";
		run;
	%end;
	
	data &outname._covars;
		set _covars1-_covars&num_variables.;
	run;
	
	%if &has_never_consumers. = 1 %then %do;
	
		**Never-consumer covariates;
		data &outname._covarsnc;
		
			%do i = 1 %to %sysfunc(countw(&never_consumer_covariates., %str( )));
			
				length covariate&i. $32.;
				covariate&i. = "%sysfunc(scan(&never_consumer_covariates., &i., %str( )))";
			%end;
			num_covariates = %sysfunc(countw(&never_consumer_covariates., %str( )));
			
			length intercept $1.;
			intercept = "&never_consumer_intercept.";
		run;
	%end;
%mend process_covariate_lists;