**Produce trace plots of beta values and means;
%macro beta_trace_plots(beta=,
												variables=,
												covariate_data=,
												num_mcmc_iterations=,
												num_burn=,
												num_thin=,
												plot_type=);
												
	%local num_variables var_j variable
				 covariates_j intercept_j
				 num_covariates covar_j covariate beta_column;
												
	%let num_variables = %sysfunc(countw(&variables., %str( )));
	
	%do var_j = 1 %to &num_variables.;
	
		%let variable = %sysfunc(scan(&variables., &var_j., %str( )));
	
		**extract covariates for variable;
		data _NULL_;
			set &covariate_data.;
			if variable = "&variable.";
			
			call symputx("num_covariates", num_covariates);
		run;
		
		data _NULL_;
			set &covariate_data.;
			if variable = "&variable.";
			
			length covariates_j $32767.;
			
			covariates_j = "";
			
			%do covar_j = 1 %to &num_covariates.;
				covariates_j = catx(" ", covariates_j, covariate&covar_j.);
			%end;
				
			call symputx("covariates_j", covariates_j);
			call symputx("intercept_j", intercept);
		run;
		
		**add iteration numbers;
		data _value_plot_data;
			set &beta.&var_j.;
			
			iteration = _N_;
		run;
		
		**plots for each beta;
		%do covar_j = 0 %to &num_covariates.;
		
			%if %upcase(&intercept_j.) = Y or &covar_j. > 0 %then %do;
			
				%if &covar_j. = 0 %then %do;
			
					%let beta_column = beta&var_j._intercept;
					%let covariate = Intercept;
				%end;
				%else %do;
			
					%let beta_column = beta&var_j._covariate&covar_j.;
					%let covariate = %sysfunc(scan(&covariates_j., &covar_j., %str( )));
				%end;
				
				%if %sysfunc(findw(&plot_type., VALUE, , %str(s))) ^= 0 %then %do;
			
					proc sgplot data=_value_plot_data;
				
						series x=iteration y=&beta_column. / lineattrs=(color=black);
					
						refline &num_burn. / axis=X lineattrs=(color=red);
					
						xaxis label="Number of Iterations";
						yaxis label="Beta Value";
					
						title "Beta Values, &variable., &covariate.";
					run;
					title;
				%end;
				
				%if %sysfunc(findw(&plot_type., MEAN, , %str(s))) ^= 0 %then %do;
				
					data _mean_plot_data;
						set _value_plot_data;
						if iteration > &num_burn. and 
							 iteration <= &num_mcmc_iterations. and 
							 mod(iteration, &num_thin.) = mod(&num_burn. + 1, &num_thin.);
					run;
			
					data _mean_plot_data;
						set _mean_plot_data;
					
						retain _sum_value _num_samples;
						
						if _N_ = 1 then do;
						
							_sum_value = 0;
							_num_samples = 0;
						end;
					
						_sum_value = _sum_value + &beta_column.;
						_num_samples = _num_samples + 1;
						
						_mean_value = _sum_value/_num_samples;
					run;
				
					proc sgplot data=_mean_plot_data;
					
						series x=iteration y=_mean_value / lineattrs=(color=black);
					
						xaxis label="Number of Iterations";
						yaxis label="Beta Mean";
					
						title "Beta Mean, &variable, &covariate.";
					run;
				%end;
			%end;
		%end;
	%end;
%mend beta_trace_plots;

**Produces trace plots of Sigma-u and Sigma-e values and means;
%macro sigma_trace_plots(sigma=,
												 component=,
												 variables=,
												 num_mcmc_iterations=,
												 num_burn=,
												 num_thin=,
												 plot_type=);
												 
	%local num_variables row row_variable col col_variable;
												 
	data _value_plot_data;
		set &sigma.;
			
		iteration = _N_;
	run;
		
	%let num_variables = %sysfunc(countw(&variables., %str( )));
		
	%do row = 1 %to &num_variables.;
		
		%let row_variable = %sysfunc(scan(&variables., &row., %str( )));
		
		%do col = 1 %to &row.;
			
			%let col_variable = %sysfunc(scan(&variables., &col., %str( )));
				
			%if %sysfunc(findw(&plot_type., VALUE, , %str(s))) ^= 0 %then %do;
				
				proc sgplot data=_value_plot_data;
					
					series x=iteration y=sigma_&component._row&row._col&col. / lineattrs=(color=black);
						
					refline &num_burn. / axis=X lineattrs=(color=red);
						
					xaxis label="Number of Iterations";
					yaxis label="Sigma-&component. Value";
						
					title "Sigma-&component. Values, &row_variable., &col_variable.";
				run;
			%end;
				
			%if %sysfunc(findw(&plot_type., MEAN, , %str(s))) ^= 0 %then %do;
			
				data _mean_plot_data;
					set _value_plot_data;
					if iteration > &num_burn. and 
						 iteration <= &num_mcmc_iterations. and
						 mod(iteration, &num_thin.) = mod(&num_burn. + 1, &num_thin.);
				run;
				
				data _mean_plot_data;
					set _mean_plot_data;
						
					retain _sum_value _num_samples;
					
					if _N_ = 1 then do;
					
						_sum_value = 0;
						_num_samples = 0;
					end;
						
					_sum_value = _sum_value + sigma_&component._row&row._col&col.;
					_num_samples = _num_samples + 1;
					
					_mean_value = _sum_value/_num_samples;
				run;
					
				proc sgplot data=_mean_plot_data;
					
					series x=iteration y=_mean_value / lineattrs=(color=black);
						
					xaxis label="Number of Iterations";
					yaxis label="Sigma-&component. Mean";
						
					title "Sigma-&component. Mean, &row_variable., &col_variable.";
				run;
			%end;
		%end;
	%end;
%mend sigma_trace_plots;

**Produces overlay of Sigma-u and Sigma-e trace plots;
%macro sigma_overlay_plots(sigma_u=,
													 sigma_e=,
													 variables=,
													 num_mcmc_iterations=,
													 num_burn=,
													 num_thin=,
													 plot_type=);
													 
	%local num_variables row row_variable col col_variable;
													 
	**combine Sigma-u and Sigma-e data side-by-side;
	data _value_plot_data;
		set &sigma_u.;
		set &sigma_e.;
		
		iteration = _N_;
	run;
	
	%let num_variables = %sysfunc(countw(&variables., %str( )));
	
	%do row = 1 %to &num_variables.;
	
		%let row_variable = %sysfunc(scan(&variables., &row., %str( )));
		
		%do col = 1 %to &row.;
		
			%let col_variable = %sysfunc(scan(&variables., &col., %str( )));
			
			%if %sysfunc(findw(&plot_type., VALUE, , %str(s))) ^= 0 %then %do;
			
				proc sgplot data=_value_plot_data;
					
					series x=iteration y=sigma_e_row&row._col&col. / lineattrs=(color=black);
					series x=iteration y=sigma_u_row&row._col&col. / lineattrs=(color=blue);
					
					refline &num_burn. / axis=X lineattrs=(color=red);
					
					xaxis label="Number of Iterations";
					yaxis label="Parameter Value";
					
					title "Overlay of Sigma-u and Sigma-e Values, &row_variable., &col_variable.";
				run;
				title;
			%end;
			
			%if %sysfunc(findw(&plot_type., MEAN, , %str(s))) ^= 0 %then %do;
			
				data _mean_plot_data;
					set _value_plot_data;
					if iteration > &num_burn. and 
						 iteration <= &num_mcmc_iterations. and 
						 mod(iteration, &num_thin.) = mod(&num_burn. + 1, &num_thin.);
				run;
				
				data _mean_plot_data;
					set _mean_plot_data;
					
					retain _sum_value_u _sum_value_e _num_samples;
					
					if _N_ = 1 then do;
						
						_sum_value_u = 0;
						_sum_value_e = 0;
						_num_samples = 0;
					end;
					
					_sum_value_u = _sum_value_u + sigma_u_row&row._col&col.;
					_sum_value_e = _sum_value_e + sigma_e_row&row._col&col.;
					_num_samples = _num_samples + 1;
					
					_mean_value_u = _sum_value_u/_num_samples;
					_mean_value_e = _sum_value_e/_num_samples;
				run;
				
				proc sgplot data=_mean_plot_data;
				
					series x=iteration y=_mean_value_e / lineattrs=(color=black);
					series x=iteration y=_mean_value_u / lineattrs=(color=blue);
					
					xaxis label="Number of Iterations";
					yaxis label="Parameter Mean";
					
					title "Overlay of Sigma-u and Sigma-e Means, &row_variable., &col_variable.";
				run;
				title;
			%end;
		%end;
	%end;
%mend sigma_overlay_plots;

**Produces trace plots of alpha1 values and means;
%macro alpha1_trace_plots(alpha1=,
													never_consumer_covariate_data=,
													num_mcmc_iterations=,
													num_burn=,
													num_thin=,
													plot_type=);
													
	%local num_covariates covar_h covariate alpha1_column;
													
	**extract covariates;
	data _NULL_;
		set &never_consumer_covariate_data.;
		
		call symputx("num_covariates", num_covariates);
	run;
	
	data _NULL_;
		set &never_consumer_covariate_data.;
		
		length never_consumer_covariates $32767.;
		
		never_consumer_covariates = "";
		
		%do covar_h = 1 %to &num_covariates.;
			never_consumer_covariates = catx(" ", never_consumer_covariates, covariate&covar_h.);
		%end;
		
		call symputx("never_consumer_covariates", never_consumer_covariates);
		call symputx("never_consumer_intercept", intercept);
	run;
	
	data _value_plot_data;
		set &alpha1.;
		
		iteration = _N_;
	run;
	
	**plots for each alpha1;
	%do covar_h = 0 %to &num_covariates.;
	
		%if %upcase(&never_consumer_intercept.) = Y or &covar_h. > 0 %then %do;
		
			%if &covar_h. = 0 %then %do;
			
				%let alpha1_column = alpha1_intercept;
				%let covariate = Intercept;
			%end;
			%else %do;
			
				%let alpha1_column = alpha1_covariate&covar_h.;
				%let covariate = %sysfunc(scan(&never_consumer_covariates., &covar_h., %str( )));
			%end;
			
			%if %sysfunc(findw(&plot_type., VALUE, , %str(s))) ^= 0 %then %do;
			
				proc sgplot data=_value_plot_data;
				
					series x=iteration y=&alpha1_column. / lineattrs=(color=black);
					
					refline &num_burn. / axis=X lineattrs=(color=red);
					
					xaxis label="Number of Iterations";
					yaxis label="Alpha1 Value";
					
					title "Alpha1 Values, &covariate.";
				run;
				title;
			%end;
			
			%if %sysfunc(findw(&plot_type., MEAN, , %str(s))) ^= 0 %then %do;
			
				data _mean_plot_data;
					set _value_plot_data;
					if iteration > &num_burn. and 
						 iteration <= &num_mcmc_iterations. and 
						 mod(iteration, &num_thin.) = mod(&num_burn. + 1, &num_thin.);
				run;
				
				data _mean_plot_data;
					set _mean_plot_data;
					
					retain _sum_value _num_samples;
					
					if _N_ = 1 then do;
					
						_sum_value = 0;
						_num_samples = 0;
					end;
					
					_sum_value = _sum_value + &alpha1_column.;
					_num_samples = _num_samples + 1;
					_mean_value = _sum_value/_num_samples;
				run;
				
				proc sgplot data=_mean_plot_data;
				
					series x=iteration y=_mean_value / lineattrs=(color=black);
					
					xaxis label="Number of Iterations";
					yaxis label="Alpha1 Mean";
					
					title "Alpha1 Means, &covariate.";
				run;
				title;
			%end;
		%end;
	%end;
%mend alpha1_trace_plots;

**Produces trace plot of average consumer probabilities for the first episodic food;
%macro consumer_probability_trace_plots(consumer_probabilities=,
																				num_mcmc_iterations=,
																				num_burn=,
																				num_thin=,
																				plot_type=);
																				
	data _value_plot_data;
		set &consumer_probabilities.;
		
		iteration = _N_;
	run;
	
	%if %sysfunc(findw(&plot_type., VALUE, , %str(s))) ^= 0 %then %do;
	
		proc sgplot data=_value_plot_data;
		
			series x=iteration y=consumer_probability1 / lineattrs=(color=black);
			
			refline &num_burn. / axis=X lineattrs=(color=red);
			
			xaxis label="Number of Iterations";
			yaxis label="Consumer Probability Value";
			
			title "Consumer Probability Values";
		run;
		title;
	%end;
	
	%if %sysfunc(findw(&plot_type., MEAN, , %str(s))) ^= 0 %then %do;
	
		data _mean_plot_data;
			set _value_plot_data;
			if iteration > &num_burn. and 
				 iteration <= &num_mcmc_iterations. and 
				 mod(iteration, &num_thin.) = mod(&num_burn. + 1, &num_thin.);
		run;
		
		data _mean_plot_data;
			set _mean_plot_data;
			
			retain _sum_value _num_samples;
			
			if _N_ = 1 then do;
			
				_sum_value = 0;
				_num_samples = 0;
			end;
			
			_sum_value = _sum_value + consumer_probability1;
			_num_samples = _num_samples + 1;
			_mean_value = _sum_value/_num_samples;
		run;
		
		proc sgplot data=_mean_plot_data;
			
			series x=iteration y=_mean_value;
			
			xaxis label="Number of Iterations";
			yaxis label="Consumer Probability Mean";
			
			title "Consumer Probability Means";
		run;
		title;
	%end;
%mend consumer_probability_trace_plots;