**Produces probability density function plots for variables in dataset;
%macro density_plots(input_data=,
										 variables=,
										 row_subset=,
										 weight=,
										 population_name=All);
										 
	%local num_variables i variable;
										 
	%let num_variables = %sysfunc(countw(&variables., %str( )));
	
	%do i = 1 %to &num_variables.;
	
		%let variable = %sysfunc(scan(&variables, &i., %str( )));
		
		proc sgplot data=&input_data.;
			%if &row_subset. ^= %str() %then %do;
				where &row_subset.;
			%end;
			
			density &variable. / type=kernel weight=&weight.;
			
			xaxis label = "&variable.";
			yaxis label = "Estimated Density";
			
			title "Density Function of &variable.";
			title2 "Population: &population_name.";
		run;
		title;
		title2;
	%end;
%mend density_plots;

%macro ecdf_plots(input_data=,
									variables=,
									row_subset=,
									weight=,
									population_name=All);
									
	%local num_variables i variable;
									
	%let num_variables = %sysfunc(countw(&variables., %str( )));
	
	%do i = 1 %to &num_variables.;
	
		%let variable = %sysfunc(scan(&variables., &i., %str( )));
	
		proc sort data=&input_data. out=_ecdf_data; by &variable.; run;
		
		data _ecdf_data;
			set _ecdf_data;
			%if &row_subset. ^= %str() %then %do;
				if &row_subset.;
			%end;
		run;
		
		data _ecdf_data;
			set _ecdf_data end=_last;
			
			retain _cumulative_weight;
			
			if _N_ = 1 then _cumulative_weight = 0;
			
			%if &weight. ^= %str() %then %do;
				
				_cumulative_weight = _cumulative_weight + &weight.;
			%end;
			%else %do;
				
				_cumulative_weight = _cumulative_weight + 1;
			%end;
			
			if _last = 1 then call symputx("sum_weights", _cumulative_weight);
		run;
		
		data _ecdf_data;
			set _ecdf_data;
			
			_ecdf = _cumulative_weight/&sum_weights.;
		run;
		
		proc sgplot data=_ecdf_data;
		
			step x=&variable. y=_ecdf;
			
			xaxis label="&variable.";
			yaxis label="Cumulative Density";
			
			title "Empirical Cumulative Density of &variable.";
			title2 "Population: &population_name.";
		run;
		title;
		title2;
	%end;
%mend ecdf_plots;